cronjobs.controllers.module('logs_modal',
    ['xhr', 'loading_spinner'],
    () => {
        return {
            vue: true,
            name: 'gx-cronjobs-logs-modal',
            parent: 'gx-cronjobs-overview',
            template: '#cronjobs-logs-modal',
            props: {
                cronjob: {
                    required: true,
                    type: Object
                }
            },
            data: () => ({
                lang: {
                    title_log_modal: jse.core.lang.translate('title_log_modal', 'cronjobs'),
                    log_modal_last_messages: jse.core.lang.translate('log_modal_last_messages', 'cronjobs'),
                    button_close: jse.core.lang.translate('BUTTON_CLOSE', 'admin_buttons')
                },
                success: null,
                log: '',
                error: ''
            }),
            watch: {
                cronjob(newVal) {
                    if (Object.keys(newVal).length > 0) {
                        this.fetchLogs();
                    }
                }
            },
            computed: {
                modalSize() {
                    const vm = this;

                    return {
                        'modal-lg': vm.success,
                        'modal-md': !vm.success
                    }
                }
            },
            methods: {
                fetchLogs() {
                    const vm = this;
                    const $logsModal = $('.logs');

                    const $target = $('.cronjob-list-elements');
                    const spinner = jse.libs.loading_spinner.show($target);

                    jse.libs.xhr.get({
                        url: './admin.php?do=CronjobAjax/getLogs&task=' + vm.cronjob.name
                    }, true).done(r => {
                        vm.success = r.success;
                        vm.log = r.log || '';
                        vm.error = r.error || '';

                        jse.libs.loading_spinner.hide(spinner);
                        $logsModal.modal('show');
                    }).fail(r => console.error(r));
                }
            },
            init: done => done()
        }
    });